on composeMailWithParameters(params)
	
	set email_recipient to (recipient of params)
    set email_recipients to (recipients of params)
	set email_subject to (subject of params)
	set email_content to (body of params)
	set email_attachments to (attachments of params)
    set email_sender to (sender of params)

	try
		tell application "Microsoft Outlook"
			activate
			set email_content to my findAndReplace(return, "<br>", email_content)
			set tmp to make new outgoing message with properties {subject:email_subject, content:email_content}
            set account of tmp to my getDefaultMailAccount(email_sender)
			if (email_recipient is not "") then
                repeat with a_recipient in email_recipients
                    make new to recipient at tmp with properties {email address:{address:(emailaddress of a_recipient), name:(name of a_recipient)}}
                end repeat
			end if
            repeat with a_file in email_attachments
                make new attachment at tmp with properties {file:a_file}
            end repeat
			open tmp
		end tell
	end try
	
end composeMailWithParameters


on getDefaultMailAccount(senderAddress)
	
	tell application "Microsoft Outlook"
		
		repeat with myaccount in exchange accounts
			if email address of myaccount is senderAddress then
				return myaccount
			end if
		end repeat
		repeat with myaccount in imap accounts
			if email address of myaccount is senderAddress then
				return myaccount
			end if
		end repeat
		return default account
	end tell
	
	
end getDefaultMailAccount


on splitString(theString, theDelimiter)
	-- save delimiters to restore old settings
	set oldDelimiters to AppleScript's text item delimiters
	-- set delimiters to delimiter to be used
	set AppleScript's text item delimiters to theDelimiter
	-- create the array
	set theArray to every text item of theString
	-- restore the old setting
	set AppleScript's text item delimiters to oldDelimiters
	-- return the result
	return theArray
end splitString


on findAndReplace(tofind, toreplace, TheString)
	set ditd to text item delimiters
	set text item delimiters to tofind
	set textItems to text items of TheString
	set text item delimiters to toreplace
	if (class of TheString is string) then
		set res to textItems as string
	else -- if (class of TheString is Unicode text) then
		set res to textItems as Unicode text
	end if
	set text item delimiters to ditd
	return res
end findAndReplace