//
//  SFPrintDocument.h
//  TextRenderer
//
//  Created by Stefan Fuerst on 06.06.16.
//  Copyright (c) 2016 Stefan Fürst. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <Quartz/Quartz.h>
#import "SFPrintDocumentSection.h"
#import "SFPrintPageView.h"
#import "SFPrintRowView.h"
#import "SFPrintColumn.h"
#import "SFPrintCellView.h"
#import "SFPrintFrameView.h"
#import "SFPrintDocumentBusyWindowController.h"
#import "SFPrintDocumentView.h"
#import "SFPrintDocumentDelegate.h"
#import "SFPrintPaper.h"


@protocol SFPrintDocumentDelegate;

@interface SFPrintDocument : NSObject

@property (nonatomic) NSSize createHeaders;
@property (nonatomic,strong) SFPrintMargins * documentMargins; /// around the pages
@property (nonatomic,strong) NSShadow * documentShadow;
#if __has_feature(objc_arc_weak)
@property (nonatomic, weak) id <SFPrintDocumentDelegate> delegate;
#else
@property (nonatomic, unsafe_unretained) id <SFPrintDocumentDelegate> delegate;
#endif
@property (nonatomic,strong) NSArray * sections;
@property (nonatomic,strong) SFPrintDocumentView * documentView;
@property (nonatomic,strong) NSColor * backgroundColor;
@property (nonatomic,strong) NSFont * font;
@property (nonatomic,strong) NSOperationQueue * operationQueue;
@property (nonatomic,strong) SFPrintDocumentBusyWindowController * busyWindowController;
@property (nonatomic) NSInteger operationCount;
@property (nonatomic) BOOL completed;
@property (nonatomic) BOOL cancelled;
@property (nonatomic,strong) PDFDocument * PDFDocument;

-(void)addToScrollView:(NSScrollView *)scrollView;
-(void)fitInScrollView:(NSScrollView *)scrollView;
-(void)writeToURL:(NSURL *)url;
-(void)printDocument:(id)sender;
-(void)setSections:(NSArray *)sections;
-(void)cancel:(id)sender;
-(BOOL)hasPages;
@end

@interface SFPrintKitPrintOperation : NSOperation
@property (nonatomic,strong) SFPrintDocumentView * printDocumentView;
-(PDFDocument *)PDFDocument;
@end


@interface SFPrintKitSaveOperation : SFPrintKitPrintOperation
@property (nonatomic,strong) NSURL * URL;
@end
