on composeMailWithParameters(params)
	
	set email_recipient to (recipient of params)
	set email_subject to (subject of params)
	set email_content to (body of params)
	set email_attachments to (attachments of params)
	tell application "Airmail"
		activate
		set email_content to my findAndReplace(return, "<br>", email_content)
		set theMessage to make new outgoing message with properties {subject:email_subject, content:email_content}
		tell theMessage
			set the_recipients to my splitString(email_recipient, ",")
			repeat with a_recipient in the_recipients
				make new to recipient at end of to recipients with properties {name:"", address:a_recipient}
			end repeat
            
            
            repeat with a_file in email_attachments
                set the_file_path to (POSIX file a_file) as string
                set aAttachment to make new mail attachment with properties {filename:the_file_path}
            end repeat
          

			compose
		end tell
	end tell
	
end composeMailWithParameters


on splitString(theString, theDelimiter)
	-- save delimiters to restore old settings
	set oldDelimiters to AppleScript's text item delimiters
	-- set delimiters to delimiter to be used
	set AppleScript's text item delimiters to theDelimiter
	-- create the array
	set theArray to every text item of theString
	-- restore the old setting
	set AppleScript's text item delimiters to oldDelimiters
	-- return the result
	return theArray
end splitString


on findAndReplace(tofind, toreplace, theString)
	set ditd to text item delimiters
	set text item delimiters to tofind
	set textItems to text items of theString
	set text item delimiters to toreplace
	if (class of theString is string) then
		set res to textItems as string
        else -- if (class of TheString is Unicode text) then
		set res to textItems as Unicode text
	end if
	set text item delimiters to ditd
	return res
end findAndReplace

