//
//  SFCSVExporter.h
//  XLBridge
//
//  Created by Stefan Fuerst on 20.06.16.
//  Copyright (c) 2016 Media Atelier. All rights reserved.
//

#import <Foundation/Foundation.h>


FOUNDATION_EXPORT NSString *const SFCSVExporterFormatExcelBinaryName;
FOUNDATION_EXPORT NSString *const SFCSVExporterFormatExcelXMLName;
FOUNDATION_EXPORT NSString *const SFCSVExporterFormatTextSemicolonSeparatedName;
FOUNDATION_EXPORT NSString *const SFCSVExporterFormatTextTabSeparatedName;
FOUNDATION_EXPORT NSString *const SFCSVExporterFormatTextCommaSeparatedName;
FOUNDATION_EXPORT NSString *const SFCSVExporterFormatJSONName;

@protocol SFCSVExporterDelegate;
@class XLSheet, XLBook, SFCSVExporterAccessoryViewController, SFCSVExporterFormat;

@interface SFCSVExporter : NSObject

@property (nonatomic,strong) NSURL * url;
@property (nonatomic,strong) NSArray * valueArray;    //// Array of Arrays
@property (nonatomic,strong) NSArray * headerArray;   //// Array of Table Headers (optional)
@property (nonatomic,strong) NSArray * keysArray;     //// Array of keys for Fields (required for some exporters)
@property (nonatomic,strong) SFCSVExporterFormat * format;       //// Exporter

@property (nonatomic) id <SFCSVExporterDelegate> delegate;
@property (nonatomic,strong) SFCSVExporterAccessoryViewController * accessoryViewController;

-(void)export;
-(BOOL)presentSavePanel;
-(BOOL)presentSavePanelWithFileName:(NSString *)defaultName;

@end


@protocol SFCSVExporterDelegate <NSObject>
@optional
-(void)exporter:(SFCSVExporter *)exporter didChangeFormat:(SFCSVExporterFormat *)format;
-(void)exporter:(SFCSVExporter *)exporter willWriteSheet:(XLSheet *)sheet;
-(void)exporter:(SFCSVExporter *)exporter willWriteBook:(XLBook *)book;
-(void)exporter:(SFCSVExporter *)exporter didAddSheet:(XLSheet *)sheet;
-(void)exporter:(SFCSVExporter *)exporter didAddBook:(XLBook *)book;
-(BOOL)exporter:(SFCSVExporter *)exporter savePanelShouldAllowFormat:(SFCSVExporterFormat *)format;

@end





