//
//  SFCSVExporterFormat.h
//  XLBridge
//
//  Created by Stefan Fuerst on 22.06.16.
//  Copyright (c) 2016 Media Atelier. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "SFCSVExporter.h"


@interface SFCSVExporterFormats : NSObject
@property (nonatomic,strong) NSMutableDictionary * formats;
-(void)registerFormat:(SFCSVExporterFormat *)format;
@end

@interface SFCSVExporterFormat : NSObject
@property (nonatomic,strong) NSArray * headerArray;
@property (nonatomic,strong) NSArray * keysArray;
@property (nonatomic,strong) NSArray * valueArray;
@property (nonatomic) SFCSVExporter * exporter;

+(void)registerFormat:(SFCSVExporterFormat *)format;
+(SFCSVExporterFormat *)formatNamed:(NSString *)string;
+(NSArray *)allFormats;
-(void)writeToURL:(NSURL *)url;
-(NSString *)extension;
-(NSString *)displayName;
-(NSString *)name;
-(NSString *)formatName;

@end
