//
//  XLFormula.h
//  XLBridge
//
//  Created by Stefan on 24.12.14.
//  Copyright (c) 2014 Media Atelier. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "XLSheet.h"

enum {
   XLFormulaResultTypeNumber = 0,
   XLFormulaResultTypeString,
   XLFormulaResultTypeDate
};
typedef NSInteger XLFormulaResultType;


enum {
   XLFormulaAutoFillNone = 0,
   XLFormulaAutoFillAbove,
   XLFormulaAutoFillLeft,
};
typedef NSInteger XLFormulaAutoFillType;

@interface XLFormula : NSObject

@property (strong,nonatomic) NSString * functionName;
@property (strong,nonatomic) NSString * cells;
@property (assign) XLFormulaResultType resultType;
@property (assign) XLFormulaAutoFillType autofillType;
@property (assign) XLSheet * sheet;
@property (assign) NSInteger row;
@property (assign) NSInteger column;




+(instancetype)mathFunction:(NSString *)functionName;
+(instancetype)mathFunction:(NSString *)functionName fillType:(XLFormulaAutoFillType)fillType;
+(instancetype)mathFunction:(NSString *)functionName cells:(NSString *)cells;
-(NSString *)formula;

@end
