//
//  SFPDFDocument.h
//
//  Created by Stefan Fuerst on 20.09.15.
//  Copyright (c) 2015 Media Atelier. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <Quartz/Quartz.h>

@interface PDFToolKitDocument : NSObject

@property (nonatomic) int cpdfDocument;

-(PDFToolKitDocument *)initWithFile:(NSString *)path;
-(PDFToolKitDocument *)initWithSize:(NSSize)size;
-(PDFToolKitDocument *)initWithData:(NSData *)data;


-(void)writeToFile:(NSString *)path;

-(NSArray *)attachments;
-(NSArray *)fonts;
-(void)addAttachment:(NSString *)path;
-(NSData *)dataRepresentation;
-(void)addAttachmentData:(NSData *)data name:(NSString *)name;

@end





@interface PDFToolKitPDFDocumentAttachment : NSObject

@property (nonatomic,strong) NSString * name;
@property (nonatomic,strong) NSData * data;
+(PDFToolKitPDFDocumentAttachment *)attachmentWithData:(NSData *)data andName:(NSString *)name;


@end


@interface PDFToolKitPDFDocument : PDFDocument

@property (nonatomic,strong) NSMutableArray * attachments;
-(void)addAttachment:(PDFToolKitPDFDocumentAttachment *)attachment;

@end

